/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.logwriters;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.MessageFormat;
import com.cloudbees.syslog.Severity;
import com.cloudbees.syslog.sender.SyslogMessageSender;
import com.cloudbees.syslog.sender.UdpSyslogMessageSender;
import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.HostAppService;
import com.enhancera.auditor.common.logwriters.AuditLogWriter;
import com.enhancera.auditor.common.logwriters.LogWriterFormattingUtils;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SyslogAuditLogWriter
implements AuditLogWriter {
    private static final Logger log = Logger.getLogger(SyslogAuditLogWriter.class);
    private final HostAppService hostAppService;
    private final SettingsService settingsService;

    public SyslogAuditLogWriter(HostAppService hostAppService, SettingsService settingsService) {
        this.hostAppService = hostAppService;
        this.settingsService = settingsService;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void write(Event event) {
        if (this.settingsService.getSettings().isWriteToSyslog()) {
            SyslogMessageSender syslogMessageSender = this.createSyslogMessageSender();
            try {
                syslogMessageSender.sendMessage(LogWriterFormattingUtils.formatEvent(event));
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when writing to Syslog audit event: " + event));
            }
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private SyslogMessageSender createSyslogMessageSender() {
        Settings settings = this.settingsService.getSettings();
        UdpSyslogMessageSender messageSender = new UdpSyslogMessageSender();
        messageSender.setDefaultMessageHostname(settings.getSyslogHost());
        messageSender.setDefaultAppName(this.hostAppService.getApplicationName() + "Auditor");
        messageSender.setDefaultFacility(Facility.fromNumericalCode(settings.getSyslogFacility()));
        messageSender.setDefaultSeverity(Severity.fromNumericalCode(settings.getSyslogLevel()));
        messageSender.setSyslogServerHostname(settings.getSyslogHost());
        messageSender.setSyslogServerPort(514);
        messageSender.setMessageFormat(MessageFormat.RFC_3164);
        return messageSender;
    }
}

