/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.jakarta.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.enhancera.auditor.common.rest.SettingsRestResourceExecutor;
import com.enhancera.servlet.jakarta.rest.JakartaResponseAdapter;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import javax.annotation.Nullable;

@Path(value="/settings")
@AdminOnly
public class JakartaSettingsRestResource {
    private final SettingsRestResourceExecutor executor;

    public JakartaSettingsRestResource(SettingsRestResourceExecutor executor) {
        this.executor = executor;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getSettings() {
        return JakartaResponseAdapter.toJakarta(this.executor.getSettings());
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @ReadOnlyAccessAllowed
    public Response setSettings(@FormParam(value="retentionPeriod") int retentionPeriod, @FormParam(value="numberOfEventsPerPage") int numberOfEventsPerPage, @FormParam(value="isSystemAdminAccessOnly") boolean isSystemAdminAccessOnly, @FormParam(value="notifiedUsers") List<String> notifiedUsers, @FormParam(value="writeToSyslog") boolean writeToSyslog, @FormParam(value="syslogHost") String syslogHost, @Nullable @FormParam(value="syslogFacility") Integer syslogFacility, @Nullable @FormParam(value="syslogLevel") Integer syslogLevel, @FormParam(value="writeToFile") boolean writeToFile, @FormParam(value="filePath") String filePath) {
        return JakartaResponseAdapter.toJakarta(this.executor.setSettings(retentionPeriod, numberOfEventsPerPage, isSystemAdminAccessOnly, notifiedUsers, writeToSyslog, syslogHost, syslogFacility, syslogLevel, writeToFile, filePath));
    }
}

