/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookService;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Optional;

public class WebhookNameByIdTransformer
extends SingleArgumentTransformer {
    private final WebhookService webhookService;

    public WebhookNameByIdTransformer(WebhookService webhookService) {
        this.webhookService = webhookService;
    }

    @Override
    public List<String> transform(String arg) {
        Integer id = Ints.tryParse(arg);
        if (id == null) {
            return this.returnIfNull();
        }
        Optional webhookObject = this.webhookService.findById(id.intValue());
        return webhookObject.isPresent() ? ConvertionUtils.values(((Webhook)webhookObject.get()).getName()) : this.returnIfNull();
    }
}

