/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.gson.Gson;
import java.util.List;

public class RetentionRulesSettingsByJsonTransformer
implements Transformer {
    @Override
    public List<String> transform(List<String> args) {
        Gson gson = new Gson();
        RetentionRule attachmentRetentionRule = gson.fromJson(args.get(0), RetentionRule.class);
        RetentionRule pageRetentionRule = gson.fromJson(args.get(1), RetentionRule.class);
        TrashRetentionRule trashRetentionRule = gson.fromJson(args.get(2), TrashRetentionRule.class);
        String attachmentRetentionRuleString = RetentionRulesSettingsByJsonTransformer.formatRetentionRule(attachmentRetentionRule);
        String pageRetentionRuleString = RetentionRulesSettingsByJsonTransformer.formatRetentionRule(pageRetentionRule);
        String trashRetentionRuleString = RetentionRulesSettingsByJsonTransformer.formatTrashRetentionRule(trashRetentionRule);
        String exemptionPermission = Boolean.parseBoolean(args.get(3)) ? "System administrators and space administrators" : "System administrators only";
        return ConvertionUtils.values(attachmentRetentionRuleString, pageRetentionRuleString, trashRetentionRuleString, exemptionPermission);
    }

    private static String formatRetentionRule(RetentionRule rule) {
        if (rule.maxNumberOfVersions != 0) {
            return "Maximum number of versions to keep - " + rule.maxNumberOfVersions;
        }
        if (rule.maxAge != 0) {
            return "Keep versions for " + rule.maxAge + " " + rule.ageUnit.toLowerCase();
        }
        return "Keep all";
    }

    private static String formatTrashRetentionRule(TrashRetentionRule rule) {
        if (!rule.keepAll) {
            return "Keep trash for " + rule.maxDeletedAge + " " + rule.deletedAgeUnit.toLowerCase();
        }
        return "Keep all";
    }

    private class RetentionRule {
        private final boolean keepAll;
        private final int maxNumberOfVersions;
        private final String ageUnit;
        private final int maxAge;

        private RetentionRule(boolean keepAll, int maxNumberOfVersions, String ageUnit, int maxAge) {
            this.keepAll = keepAll;
            this.maxNumberOfVersions = maxNumberOfVersions;
            this.ageUnit = ageUnit;
            this.maxAge = maxAge;
        }
    }

    private class TrashRetentionRule {
        private final String deletedAgeUnit;
        private final boolean keepAll;
        private final int maxDeletedAge;

        private TrashRetentionRule(String deletedAgeUnit, boolean keepAll, int maxDeletedAge) {
            this.deletedAgeUnit = deletedAgeUnit;
            this.keepAll = keepAll;
            this.maxDeletedAge = maxDeletedAge;
        }
    }
}

