/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.confluence.transformers.PageTemplateParametersByIdTransformer;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class PageTemplateCategoryByIdTransformer
extends PageTemplateParametersByIdTransformer {
    private static final Map<String, String> CATEGORY_NAMES = ImmutableMap.builder().put("tc-on-space-blueprint", "Team Calendars Blueprint").put("sharelinks-blueprint", "Share links Blueprint").put("task-report-blueprint", "Task report blueprint").put("requirements-blueprint", "Product Requirements Blueprint").put("meeting-notes-blueprint", "Meeting notes Blueprint").put("healthmonitor-blueprint", "Health Monitor Blueprint").put("dacidecision-blueprint", "DACI Decision Blueprint").put("file-list-blueprint", "File list Blueprint").put("kb-troubleshooting-article-blueprint", "Troubleshooting blueprint").put("projectposter-blueprint", "Project Poster Blueprint").put("experiencecanvas-blueprint", "Experience Canvas Blueprint").put("retrospectives-blueprint", "Retrospective Blueprint").put("jirareports-blueprint", "Jira Report Blueprint").put("kb-how-to-article-blueprint", "How-to blueprint").put("decisions-blueprint", "Decisions Blueprint").build();

    public PageTemplateCategoryByIdTransformer(PageTemplateManager pageTemplateManager) {
        super(pageTemplateManager);
    }

    @Override
    public String parametersName() {
        return "category";
    }

    @Override
    public List<String> parametersValue(PageTemplate pageTemplate) {
        return ConvertionUtils.values(CATEGORY_NAMES.getOrDefault(pageTemplate.getReferencingModuleKey(), pageTemplate.getReferencingModuleKey()));
    }
}

