/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.util.List;

public class PagePermissionParametersByIdTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(PagePermissionParametersByIdTransformer.class);
    private final ContentPermissionManager contentPermissionManager;
    private final PageManager pageManager;

    public PagePermissionParametersByIdTransformer(ContentPermissionManager contentPermissionManager, PageManager pageManager) {
        this.contentPermissionManager = contentPermissionManager;
        this.pageManager = pageManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        Page page = this.pageManager.getPage(Long.parseLong(args.get(0)));
        long id = Long.parseLong(args.get(1));
        ContentPermission permission = this.getPermission(id, page, "View");
        if (permission == null) {
            permission = this.getPermission(id, page, "Edit");
        }
        if (permission == null) {
            log.error("Error obtaining page permission by ID: " + id, new Object[0]);
            return ConvertionUtils.nullValues(3);
        }
        return ConvertionUtils.values(permission.getType(), permission.getGroupName(), permission.getUserSubject() == null ? null : permission.getUserSubject().getName());
    }

    private ContentPermission getPermission(long id, Page page, String type) {
        for (ContentPermissionSet permissionSet : this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)page, type)) {
            for (ContentPermission permission : permissionSet) {
                if (permission.getId() != id) continue;
                return permission;
            }
        }
        return null;
    }
}

