/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConfigurationFileNameByIdTransformer
extends SingleArgumentTransformer {
    private static final Map<String, String> NAMES = ImmutableMap.builder().put("application-properties", "Application properties").put("application-config", "Confluence configuration").put("auth-cfg", "Authentication configuration").put("cache-cfg", "Cache configuration").put("synchrony-config", "Synchrony configuration").put("tomcat-config", "Tomcat configuration").put("application-logs", "Confluence application logs").put("tomcat-access-logs", "Tomcat access logs").put("tomcat-logs", "Tomcat logs").put("confluence-customisations", "Confluence customisations").put("healthchecks", "Status of health checks").put("jfr-bundle", "Runtime diagnostics data").put("thread-dump", "Thread dumps").build();

    @Override
    public List<String> transform(String arg) {
        String[] keys = arg.split(", ");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            result.add(NAMES.getOrDefault(keys[i], keys[i]));
        }
        return ConvertionUtils.values(result);
    }
}

