/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.util;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventDetail;
import com.enhancera.auditor.common.EventStorage;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class FileEventStorage
implements EventStorage {
    private static final FormattingLogger log = FormattingLogger.getLogger(FileEventStorage.class);
    private Path path;

    public FileEventStorage(Path path) {
        this.path = path;
    }

    @Override
    public void storeEvent(Event event) {
        this.clean();
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                Files.createFile(this.path, new FileAttribute[0]);
            }
            Gson gson = new Gson();
            SerializableEvent serializableEvent = new SerializableEvent(event);
            try (FileWriter writer = new FileWriter(this.path.toFile());){
                gson.toJson((Object)serializableEvent, (Appendable)writer);
            }
        }
        catch (IOException e) {
            log.error(e, "Error writing event to the file: ", this.path);
        }
    }

    @Override
    public Event restoreEvent() {
        Event event = null;
        if (Files.exists(this.path, new LinkOption[0])) {
            try {
                Gson gson = new Gson();
                try (FileReader reader = new FileReader(this.path.toFile());){
                    SerializableEvent serializableEvent = gson.fromJson((Reader)reader, SerializableEvent.class);
                    event = serializableEvent.toEvent();
                }
            }
            catch (JsonSyntaxException | IOException e) {
                log.error(e, "Error reading event from the file: ", this.path);
                this.clean();
            }
        }
        return event;
    }

    @Override
    public void clean() {
        try {
            Files.deleteIfExists(this.path);
        }
        catch (IOException e) {
            log.error(e, "Error deleting event file: ", this.path);
        }
    }

    private static class SerializableEvent
    implements Serializable {
        private String author;
        private String ipAddress;
        private long time;
        private String category;
        private String summary;
        private String object;
        private List<SerializableEventDetail> details;

        SerializableEvent() {
        }

        SerializableEvent(Event event) {
            this.author = event.getAuthor();
            this.ipAddress = event.getIpAddress();
            this.time = event.getTime().toEpochMilli();
            this.category = event.getCategory();
            this.summary = event.getSummary();
            this.object = event.getObject();
            this.details = event.getDetails().stream().map(SerializableEventDetail::new).collect(Collectors.toList());
        }

        Event toEvent() {
            return new Event(this.author, this.ipAddress, Instant.ofEpochMilli(this.time), this.category, this.summary, this.object, this.details.stream().map(SerializableEventDetail::toEventDetail).collect(Collectors.toList()));
        }
    }

    private static class SerializableEventDetail {
        String name;
        String oldValue;
        String newValue;
        String unchangedValue;
        boolean diff;

        SerializableEventDetail() {
        }

        SerializableEventDetail(EventDetail eventDetail) {
            this.name = eventDetail.getName();
            this.oldValue = eventDetail.getOldValue();
            this.newValue = eventDetail.getNewValue();
            this.unchangedValue = eventDetail.getUnchangedValue();
            this.diff = eventDetail.isDiff();
        }

        EventDetail toEventDetail() {
            return new EventDetail(this.name, this.oldValue, this.newValue, this.diff);
        }
    }
}

