/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.DateFormatter;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class AuditorLicenseDetailsTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(AuditorLicenseDetailsTransformer.class);
    private final PluginLicenseManager pluginLicenseManager;
    private final DateFormatter dateFormatter;

    public AuditorLicenseDetailsTransformer(DateFormatter dateFormatter, PluginLicenseManager pluginLicenseManager) {
        this.dateFormatter = dateFormatter;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        Option licenseOption = this.pluginLicenseManager.getLicense();
        PluginLicense license = null;
        if (licenseOption.isDefined()) {
            license = (PluginLicense)licenseOption.get();
        }
        if (license == null) {
            return ConvertionUtils.nullValues(3);
        }
        String expiryDate = this.getExpiryDate(license);
        String type = license.isEvaluation() ? "Evaluation" : license.getLicenseType().name();
        String supportNumber = license.getSupportEntitlementNumber().isDefined() ? (String)license.getSupportEntitlementNumber().get() : null;
        return ConvertionUtils.values(type, expiryDate, supportNumber);
    }

    private String getExpiryDate(PluginLicense license) {
        String expiryDate;
        try {
            long millis;
            Object dateTimeObject = license.getExpiryDate().get();
            try {
                Method getMillis = dateTimeObject.getClass().getMethod("getMillis", new Class[0]);
                millis = (Long)getMillis.invoke(dateTimeObject, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error(e, "Error occured while getting Auditor plugin expiry date", new Object[0]);
                return null;
            }
            Date dateTime = new Date(millis);
            expiryDate = this.dateFormatter.format(dateTime);
        }
        catch (NoSuchMethodError e) {
            Optional expiryZonedDate;
            try {
                Method method = license.getClass().getMethod("getExpiryZonedDate", new Class[0]);
                expiryZonedDate = (Optional)method.invoke((Object)license, new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                log.error(ex, "Error occured while getting Auditor plugin expiry date", new Object[0]);
                return null;
            }
            expiryDate = expiryZonedDate.map(zonedDateTime -> this.dateFormatter.format(Date.from(zonedDateTime.toInstant()))).orElse(null);
        }
        return expiryDate;
    }
}

