/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.util.Objects;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="trail")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PagedEvents {
    private List<Event> events;
    private int startIndex;
    private int endIndex;
    private int pageNumber;
    private int resultsPerPage;
    private int totalSize;
    private int startResult;
    private int endResult;
    private int lastPage;
    private int prevPage;
    private int nextPage;
    private boolean onFirstPage;
    private boolean onLastPage;
    private boolean showPrevPage;
    private boolean showNextPage;
    private boolean showPrevEllipsis;
    private boolean showNextEllipsis;

    public PagedEvents() {
        throw new UnsupportedOperationException("No-arg constructor is just to make JAXB happy");
    }

    public PagedEvents(List<Event> events, int startIndex, int endIndex, int pageNumber, int resultsPerPage, int totalSize) {
        this.events = events;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.pageNumber = pageNumber;
        this.resultsPerPage = resultsPerPage;
        this.totalSize = totalSize;
        this.startResult = startIndex + 1;
        this.endResult = endIndex;
        this.lastPage = (totalSize - 1) / resultsPerPage + 1;
        this.onFirstPage = startIndex == 0;
        boolean bl = this.onLastPage = endIndex == totalSize;
        if (pageNumber > 1) {
            this.prevPage = pageNumber - 1;
        }
        this.showPrevPage = pageNumber > 2;
        boolean bl2 = this.showPrevEllipsis = pageNumber > 3;
        if (pageNumber < this.lastPage) {
            this.nextPage = pageNumber + 1;
        }
        this.showNextPage = pageNumber < this.lastPage - 1;
        this.showNextEllipsis = pageNumber < this.lastPage - 2;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("events", this.events).add("startIndex", (Object)this.startIndex).add("endIndex", (Object)this.endIndex).add("pageNumber", (Object)this.pageNumber).add("resultsPerPage", (Object)this.resultsPerPage).add("totalSize", (Object)this.totalSize).add("startResult", (Object)this.startResult).add("endResult", (Object)this.endResult).add("prevPage", (Object)this.prevPage).add("nextPage", (Object)this.nextPage).add("showPrevPage", (Object)this.showPrevPage).add("showNextPage", (Object)this.showNextPage).add("showPrevEllipsis", (Object)this.showPrevEllipsis).add("showNextEllipsis", (Object)this.showNextEllipsis).add("onFirstPage", (Object)this.onFirstPage).add("onLastPage", (Object)this.onLastPage).toString();
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getStartResult() {
        return this.startResult;
    }

    public int getEndResult() {
        return this.endResult;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public int getPrevPage() {
        return this.prevPage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public boolean isOnFirstPage() {
        return this.onFirstPage;
    }

    public boolean isOnLastPage() {
        return this.onLastPage;
    }

    public boolean isShowPrevPage() {
        return this.showPrevPage;
    }

    public boolean isShowNextPage() {
        return this.showNextPage;
    }

    public boolean isShowPrevEllipsis() {
        return this.showPrevEllipsis;
    }

    public boolean isShowNextEllipsis() {
        return this.showNextEllipsis;
    }
}

