/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common;

import java.time.Duration;
import java.time.Instant;

public class Interval {
    private final Instant start;
    private final Instant end;

    public Interval(Instant start, Instant end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Start or end are null");
        }
        if (end.isBefore(start)) {
            throw new IllegalArgumentException("End must not be before start");
        }
        this.start = start;
        this.end = end;
    }

    public Interval(long startMillis, long endMillis) {
        this(Instant.ofEpochMilli(startMillis), Instant.ofEpochMilli(endMillis));
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public Duration toDuration() {
        return Duration.between(this.start, this.end);
    }

    public boolean contains(Instant instant) {
        return !instant.isBefore(this.start) && instant.isBefore(this.end);
    }
}

