/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common;

import com.enhancera.auditor.common.util.Objects;
import com.google.common.base.Strings;
import java.io.Serializable;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class EventDetail
implements Serializable {
    public static final String SEARCHABLE_STRING_SEPARATOR = "|";
    private String name;
    @Nullable
    private String oldValue;
    @Nullable
    private String newValue;
    @Nullable
    private String unchangedValue;
    private boolean diff;

    public EventDetail() {
        throw new UnsupportedOperationException("No-arg constructor is just to make JAXB happy");
    }

    public EventDetail(String name, String oldValue, String newValue, boolean diff) {
        this.name = name;
        this.oldValue = Strings.emptyToNull(oldValue);
        this.newValue = Strings.emptyToNull(newValue);
        this.diff = diff;
        if (diff) {
            this.unchangedValue = null;
        } else {
            if (this.oldValue == null) {
                this.unchangedValue = this.newValue;
            }
            if (this.newValue == null) {
                this.unchangedValue = this.oldValue;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String getUnchangedValue() {
        return this.unchangedValue;
    }

    public boolean isDiff() {
        return this.diff;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.oldValue, this.newValue, this.unchangedValue, this.diff);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventDetail other = (EventDetail)obj;
        return Objects.equal(this.name, other.name) && Objects.equal(this.oldValue, other.oldValue) && Objects.equal(this.newValue, other.newValue) && Objects.equal(this.unchangedValue, other.unchangedValue) && this.diff == other.diff;
    }

    public String toString() {
        Objects.ToStringHelper stringHelper = Objects.toStringHelper(this).add("name", this.name);
        if (this.diff) {
            stringHelper.add("oldValue", this.oldValue).add("newValue", this.newValue);
        } else {
            stringHelper.add("value", this.unchangedValue);
        }
        return stringHelper.toString();
    }

    @Nullable
    public EventDetail withNewValue(String value) {
        String newValue = Strings.emptyToNull(value);
        if (Objects.equal(this.oldValue, newValue)) {
            return null;
        }
        return new EventDetail(this.name, this.oldValue, newValue, this.diff);
    }

    public String toSearchableString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase());
        if (this.getOldValue() != null) {
            sb.append(SEARCHABLE_STRING_SEPARATOR).append(this.getOldValue().toLowerCase());
        }
        if (this.getNewValue() != null) {
            sb.append(SEARCHABLE_STRING_SEPARATOR).append(this.getNewValue().toLowerCase());
        }
        return sb.toString();
    }
}

