/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.HostAppService;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.logwriters.AuditLogWriter;
import com.enhancera.auditor.common.util.FileEventStorage;
import com.google.common.collect.ImmutableList;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;

public abstract class BackupRestoringEventTracker
extends FileEventStorage {
    private final DataLayer dataLayer;
    private final AuditLogWriter logWriter;

    public BackupRestoringEventTracker(HostAppService hostAppService, DataLayer dataLayer, AuditLogWriter logWriter) {
        super(Paths.get(hostAppService.getDataDirectoryPath(), "backup"));
        this.dataLayer = dataLayer;
        this.logWriter = logWriter;
    }

    public abstract boolean isBackupRestoringEvent(Event var1);

    public void check() {
        Event latestBackupRestoringEvent = this.restoreEvent();
        if (latestBackupRestoringEvent != null && this.dataLayer.readEvents(EventCriteria.builder().setTime(latestBackupRestoringEvent.getTime()).setSummaries(ImmutableList.of(latestBackupRestoringEvent.getSummary())).setAuthors(ImmutableList.of(latestBackupRestoringEvent.getAuthor())).build()).isEmpty()) {
            if (latestBackupRestoringEvent.getTime().isBefore(Instant.now().minus(Duration.ofDays(1L)))) {
                this.clean();
            } else {
                this.logWriter.write(latestBackupRestoringEvent);
            }
        }
    }
}

