/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpaceNamesByKeysTransformer
extends SingleArgumentTransformer {
    private final SpaceManager spaceManager;

    public SpaceNamesByKeysTransformer(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    @Override
    public List<String> transform(String arg) {
        List<String> spaceKeys = Arrays.asList(arg.split(", "));
        ArrayList<String> spaceNames = new ArrayList<String>();
        for (String spaceKey : spaceKeys) {
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space == null) continue;
            spaceNames.add(space.getName());
        }
        return ConvertionUtils.values(spaceNames);
    }
}

