/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.jakarta.trail;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.user.UserManager;
import com.enhancera.auditor.common.trail.TrailViewServletExecutor;
import com.enhancera.servlet.jakarta.rest.JakartaHttpRequestAdapter;
import com.enhancera.servlet.jakarta.rest.JakartaHttpResponseAdapter;
import com.enhancera.servlet.jakarta.util.UserRedirect;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@AdminOnly
public class TrailViewServlet
extends HttpServlet {
    private static final long serialVersionUID = -2495621092543840536L;
    private final TrailViewServletExecutor executor;
    private final UserRedirect userRedirect;
    private final UserManager userManager;

    public TrailViewServlet(TrailViewServletExecutor executor, UserRedirect userRedirect, UserManager userManager) {
        this.executor = executor;
        this.userRedirect = userRedirect;
        this.userManager = userManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.userRedirect.redirectIfNotAllowed(request, response)) {
            return;
        }
        String username = this.userManager.getRemoteUser().getUsername();
        this.executor.doGet(new JakartaHttpRequestAdapter(request), new JakartaHttpResponseAdapter(response), username);
    }
}

