/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.util.List;

public abstract class ColorSchemeColorsBySpaceKeyTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(ColorSchemeColorsBySpaceKeyTransformer.class);
    private final ColourSchemeManager colourSchemeManager;

    public ColorSchemeColorsBySpaceKeyTransformer(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        ColourScheme scheme = args.isEmpty() ? this.colourSchemeManager.getGlobalColourScheme() : this.colourSchemeManager.getSpaceColourScheme(args.get(0));
        List<String> properties = this.getColorSchemeProperties();
        if (scheme == null) {
            log.error("Color scheme not found for space key: " + args.get(0), new Object[0]);
            return ConvertionUtils.nullValues(properties.size());
        }
        return ConvertionUtils.values(properties.stream().map(arg_0 -> ((ColourScheme)scheme).get(arg_0)).toArray());
    }

    public abstract List<String> getColorSchemeProperties();
}

