/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.configuration;

import com.enhancera.auditor.common.HostAppService;
import com.enhancera.auditor.common.RequestProcessorImpl;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.configuration.ConfigurationService;
import com.enhancera.auditor.configuration.RootConfig;
import com.google.common.base.Throwables;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final FormattingLogger log = FormattingLogger.getLogger(RequestProcessorImpl.class);
    private RootConfig config = null;

    public ConfigurationServiceImpl(HostAppService hostAppService) {
        try (BufferedReader configReader = new BufferedReader(new InputStreamReader(RequestProcessorImpl.class.getResourceAsStream(hostAppService.getConfigPath()), "UTF-8"));){
            RootConfig.Builder configBuilder = RootConfig.newBuilder();
            TextFormat.merge(configReader, (Message.Builder)configBuilder);
            this.config = configBuilder.build();
        }
        catch (IOException e) {
            log.error(e, "Error reading audit tracking configuration!", new Object[0]);
            Throwables.propagate(e);
        }
    }

    @Override
    public RootConfig getConfiguration() {
        return this.config;
    }
}

