/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.trail;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.enhancera.auditor.common.DataOption;
import com.enhancera.auditor.common.DataOptionType;
import com.enhancera.auditor.common.DataOptionsProvider;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.HostAppService;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.rest.GenericHttpRequest;
import com.enhancera.auditor.common.rest.GenericHttpResponse;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.LicenseCheckResult;
import com.enhancera.auditor.common.util.LicenseChecker;
import com.enhancera.auditor.common.util.UserUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@AdminOnly
public class TrailViewServletExecutor {
    private static final FormattingLogger log = FormattingLogger.getLogger(TrailViewServletExecutor.class);
    private final UserManager userManager;
    private final UserUtils userUtils;
    private final TemplateRenderer renderer;
    private final PluginLicenseManager pluginLicenseManager;
    private final HostAppService hostAppService;
    private final LicenseChecker licenseChecker;
    private final SettingsService settingsService;
    private final DataOptionsProvider dataOptionsProvider;

    public TrailViewServletExecutor(UserManager userManager, UserUtils userUtils, TemplateRenderer renderer, PluginLicenseManager pluginLicenseManager, HostAppService hostAppService, LicenseChecker licenseChecker, DataOptionsProvider dataOptionsProvider, SettingsService settingsService) {
        this.userUtils = userUtils;
        this.userManager = userManager;
        this.renderer = renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.hostAppService = hostAppService;
        this.licenseChecker = licenseChecker;
        this.settingsService = settingsService;
        this.dataOptionsProvider = dataOptionsProvider;
    }

    public void doGet(GenericHttpRequest request, GenericHttpResponse response, String username) throws IOException {
        EventCriteria criteria = EventCriteria.create(request);
        Settings settings = this.settingsService.getSettings();
        String pageString = request.getParameter("page");
        int page = pageString == null ? 1 : Integer.parseInt(pageString);
        String searchQuery = criteria.getSearchQuery();
        Long fromTime = null;
        Long toTime = null;
        if (criteria.getInterval() != null) {
            if (criteria.getInterval().getStart().toEpochMilli() != 0L) {
                fromTime = criteria.getInterval().getStart().toEpochMilli();
            }
            if (criteria.getInterval().getEnd().toEpochMilli() != Long.MAX_VALUE) {
                toTime = criteria.getInterval().getEnd().toEpochMilli();
            }
        }
        List<DataOption> selectedAuthors = this.getDataOptions(DataOptionType.AUTHOR, criteria.getAuthors());
        List<DataOption> selectedIps = this.getDataOptions(DataOptionType.IP, criteria.getIpAddresses());
        List<DataOption> selectedCategories = this.getDataOptions(DataOptionType.CATEGORY, criteria.getCategories());
        List<DataOption> selectedSummaries = this.getDataOptions(DataOptionType.SUMMARY, criteria.getSummaries());
        List<DataOption> selectedObjects = this.getDataOptions(DataOptionType.OBJECT, criteria.getObjects());
        HashSet<User> users = new HashSet<User>(settings.getNotifiedUsers());
        List<User> admins = settings.isSystemAdminAccessOnly() ? this.userUtils.getSystemAdmins() : this.userUtils.getAdmins();
        users.addAll(admins);
        LinkedHashMap<String, Object> context = Maps.newLinkedHashMap();
        context.put("page", page);
        context.put("isSystemAdmin", this.userManager.isSystemAdmin(username));
        context.put("searchQuery", searchQuery);
        context.put("fromTime", fromTime);
        context.put("toTime", toTime);
        context.put("selectedAuthors", selectedAuthors);
        context.put("selectedIps", selectedIps);
        context.put("selectedCategories", selectedCategories);
        context.put("selectedSummaries", selectedSummaries);
        context.put("selectedObjects", selectedObjects);
        context.put("users", users);
        LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense((Option<PluginLicense>)this.pluginLicenseManager.getLicense());
        if (!licenseCheckResult.isOk()) {
            log.error("Audit logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
            context.put("error", licenseCheckResult.getMessage());
        }
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render(this.hostAppService.getTrailVelocityPath(), context, (Writer)response.getWriter());
    }

    private List<DataOption> getDataOptions(DataOptionType type, Collection<String> dataTexts) {
        ArrayList<DataOption> res = new ArrayList<DataOption>();
        if (dataTexts != null) {
            for (String text : dataTexts) {
                Iterator<DataOption> iterator = this.dataOptionsProvider.findDataOptions(type, text, true).iterator();
                if (!iterator.hasNext()) continue;
                res.add(iterator.next());
            }
        }
        return res;
    }
}

