/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.rest;

import com.atlassian.sal.api.user.UserManager;
import com.enhancera.auditor.common.BackupRestoringEventTracker;
import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.PagedEvents;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.logwriters.AuditLogWriter;
import com.enhancera.auditor.common.rest.GenericHttpRequest;
import com.enhancera.auditor.common.rest.ServiceResponse;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.IpExtractor;
import com.enhancera.auditor.common.util.UserUtils;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.List;

public class AuditLogResourceExecutor {
    private static final FormattingLogger log = FormattingLogger.getLogger(AuditLogResourceExecutor.class);
    private final DataLayer dataLayer;
    private final AuditLogWriter logWriter;
    private final UserManager userManager;
    private final UserUtils userUtils;
    private final SettingsService settingsService;
    private final BackupRestoringEventTracker backupRestoringEventTracker;
    private final IpExtractor ipExtractor;

    public AuditLogResourceExecutor(DataLayer dataLayer, AuditLogWriter logWriter, UserManager userManager, UserUtils userUtils, SettingsService settingsService, BackupRestoringEventTracker backupRestoringEventTracker, IpExtractor ipExtractor) {
        this.dataLayer = dataLayer;
        this.logWriter = logWriter;
        this.userManager = userManager;
        this.userUtils = userUtils;
        this.settingsService = settingsService;
        this.backupRestoringEventTracker = backupRestoringEventTracker;
        this.ipExtractor = ipExtractor;
    }

    public ServiceResponse getTrail(Integer page, String query, Long fromTime, Long toTime, List<String> users, List<String> ips, List<String> categories, List<String> summaries, List<String> objects) {
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to view audit trail.", user);
            return ServiceResponse.serverError().status(403).build();
        }
        this.backupRestoringEventTracker.check();
        int pageNumber = page == null ? 1 : page;
        int resultsPerPage = settings.getNumberOfEventsPerPage();
        log.debug("Showing %d results on page %d", resultsPerPage, pageNumber);
        EventCriteria criteria = EventCriteria.create(query, fromTime, toTime, users, ips, categories, summaries, objects);
        PagedEvents events = this.dataLayer.readPagedEvents(criteria, pageNumber, resultsPerPage);
        return ServiceResponse.ok(events).build();
    }

    public ServiceResponse delete(GenericHttpRequest request) {
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to delete audit trail.", user);
            return ServiceResponse.serverError().status(403).build();
        }
        log.info("Deleting all stored log entities", new Object[0]);
        Event event = new Event(username, this.ipExtractor.extractIpAddress(request), Instant.now(), "Auditor", "Audit log deleted", "Auditor", ImmutableList.of());
        this.backupRestoringEventTracker.clean();
        this.dataLayer.deleteEvents(EventCriteria.ALL);
        this.logWriter.write(event);
        return ServiceResponse.ok().build();
    }
}

