/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common;

import com.enhancera.auditor.common.EventDetail;
import com.enhancera.auditor.common.util.DateFormatter;
import com.enhancera.auditor.common.util.DateFormatterAccessor;
import com.enhancera.auditor.common.util.InstantAdapter;
import com.enhancera.auditor.common.util.Objects;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Event
implements Serializable {
    private String author;
    private String ipAddress;
    @XmlJavaTypeAdapter(value=InstantAdapter.class)
    private Instant time;
    private String uiDateTime;
    private String category;
    private String summary;
    private String object;
    private List<EventDetail> details;

    public Event() {
        throw new UnsupportedOperationException("No-arg constructor is just to make JAXB happy");
    }

    public Event(String author, String ipAddress, Instant time, String category, String summary, String object, List<EventDetail> details) {
        this.author = author;
        this.ipAddress = ipAddress;
        this.time = time;
        this.category = category;
        this.summary = summary;
        this.object = object;
        this.details = ImmutableList.copyOf(details);
        DateFormatter formatter = DateFormatterAccessor.getDateFormatter();
        this.uiDateTime = formatter != null ? formatter.format(Date.from(time)) : Date.from(time).toString();
    }

    public String getAuthor() {
        return this.author;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Instant getTime() {
        return this.time;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getObject() {
        return this.object;
    }

    public List<EventDetail> getDetails() {
        return this.details;
    }

    public String getUiDateTime() {
        return this.uiDateTime;
    }

    public int hashCode() {
        return Objects.hashCode(this.author, this.ipAddress, this.time, this.category, this.summary, this.object, this.details);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equal(this.author, other.author) && Objects.equal(this.ipAddress, other.ipAddress) && Objects.equal(this.time, other.time) && Objects.equal(this.category, other.category) && Objects.equal(this.summary, other.summary) && Objects.equal(this.object, other.object) && Objects.equal(this.details, other.details);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("author", this.author).add("ipAddress", this.ipAddress).add("time", this.time).add("category", this.category).add("summary", this.summary).add("object", this.object).add("details", this.details).toString();
    }

    public Event withObject(String object) {
        return object == null ? this : new Event(this.author, this.ipAddress, this.time, this.category, this.summary, object, this.details);
    }

    public Event withDetails(List<EventDetail> details) {
        return new Event(this.author, this.ipAddress, this.time, this.category, this.summary, this.object, details);
    }

    public String toSearchableString() {
        StringBuilder sb = new StringBuilder().append(this.getAuthor().toLowerCase()).append("|").append(this.getIpAddress().toLowerCase()).append("|").append(this.getCategory().toLowerCase()).append("|").append(this.getSummary().toLowerCase()).append("|").append(Objects.firstNonNull(this.getObject(), "").toLowerCase()).append("|").append(Event.constructSearchableDetails(this.getDetails()));
        return sb.toString();
    }

    private static String constructSearchableDetails(List<EventDetail> details) {
        return Joiner.on("|").join(Lists.transform(details, new Function<EventDetail, String>(){

            @Override
            public String apply(EventDetail detail) {
                return detail.toSearchableString();
            }
        }));
    }
}

