/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.javax.util;

import com.atlassian.sal.api.web.context.HttpContext;
import com.enhancera.auditor.common.rest.GenericHttpRequest;
import com.enhancera.auditor.common.util.IpExtractor;
import com.enhancera.servlet.javax.rest.JavaxHttpRequestAdapter;
import com.enhancera.servlet.javax.util.RequestUtils;
import javax.servlet.http.HttpServletRequest;

public class JavaxIpExtractor
implements IpExtractor {
    private final HttpContext httpContext;

    public JavaxIpExtractor(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    @Override
    public String extractIpAddress(GenericHttpRequest request) {
        if (!(request instanceof JavaxHttpRequestAdapter)) {
            return "-";
        }
        JavaxHttpRequestAdapter javaxHttpRequest = (JavaxHttpRequestAdapter)request;
        return RequestUtils.extractIpAddress(javaxHttpRequest.getDelegate());
    }

    @Override
    public GenericHttpRequest getCurrentRequest() {
        return new JavaxHttpRequestAdapter(this.httpContext.getRequest());
    }

    @Override
    public String getCurrentIp() {
        HttpServletRequest request = this.httpContext.getRequest();
        return RequestUtils.extractIpAddress(request);
    }
}

