/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.javax.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.enhancera.auditor.common.rest.ServiceResponse;
import com.enhancera.auditor.common.rest.UpgradeServiceExecutor;
import com.enhancera.servlet.javax.rest.JavaxResponseAdapter;
import java.util.Optional;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/upgrade")
@AdminOnly
public class JavaxUpgradeService {
    private final UpgradeServiceExecutor executor;

    public JavaxUpgradeService(UpgradeServiceExecutor executor) {
        this.executor = executor;
    }

    @GET
    @Produces(value={"application/json"})
    public Response currentStatus() {
        Optional<ServiceResponse> response = this.executor.currentStatus();
        if (!response.isPresent()) {
            return Response.serverError().build();
        }
        return JavaxResponseAdapter.toJavax(response.get());
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response removeErrors() {
        Optional<ServiceResponse> response = this.executor.removeErrors();
        if (!response.isPresent()) {
            return Response.serverError().build();
        }
        return JavaxResponseAdapter.toJavax(response.get());
    }
}

