/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence;

import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.OptionalUtils;
import com.enhancera.auditor.confluence.OsgiUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import org.springframework.context.ApplicationContext;

public class CreateContentService {
    private static final FormattingLogger log = FormattingLogger.getLogger(CreateContentService.class);
    private Object contentBlueprintManager;

    private void loadBeansFromCreateContentAppContext() {
        ApplicationContext appCtx;
        if (this.contentBlueprintManager == null && (appCtx = OptionalUtils.parseOptionalValue("createContentAppCtx", OsgiUtils.getAppCtx("com.atlassian.confluence.plugins.confluence-create-content-plugin"))) != null) {
            this.contentBlueprintManager = appCtx.getBean("contentBlueprintManager");
        }
    }

    public Optional<String> getBlueprintName(UUID uuid) {
        this.loadBeansFromCreateContentAppContext();
        try {
            Method getBlueprintByIdMethod = this.contentBlueprintManager.getClass().getMethod("getById", UUID.class);
            Object blueprint = getBlueprintByIdMethod.invoke(this.contentBlueprintManager, uuid);
            Method getNameMethod = blueprint.getClass().getMethod("getI18nNameKey", new Class[0]);
            return Optional.of(getNameMethod.invoke(blueprint, new Object[0]).toString());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error(e, "Error occurred while getting blueprint object data from confluence-create-content-plugin ContentBlueprintManager.", new Object[0]);
            return Optional.empty();
        }
    }
}

