/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.DateFormatter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;

public class AuditorLicenseDetailsTransformer
implements Transformer {
    private final PluginLicenseManager pluginLicenseManager;
    private final DateFormatter dateFormatter;

    public AuditorLicenseDetailsTransformer(DateFormatter dateFormatter, PluginLicenseManager pluginLicenseManager) {
        this.dateFormatter = dateFormatter;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        Option licenseOption = this.pluginLicenseManager.getLicense();
        PluginLicense license = null;
        if (licenseOption.isDefined()) {
            license = (PluginLicense)licenseOption.get();
        }
        if (license == null) {
            return ConvertionUtils.nullValues(3);
        }
        String expiryDate = this.getExpiryDate(license);
        String type = license.isEvaluation() ? "Evaluation" : license.getLicenseType().name();
        String supportNumber = license.getSupportEntitlementNumber().isDefined() ? (String)license.getSupportEntitlementNumber().get() : null;
        return ConvertionUtils.values(type, expiryDate, supportNumber);
    }

    private String getExpiryDate(PluginLicense license) {
        String expiryDate;
        try {
            expiryDate = license.getExpiryDate().isDefined() ? this.dateFormatter.format(((DateTime)license.getExpiryDate().get()).toDate()) : null;
        }
        catch (NoSuchMethodError e) {
            Optional expiryZonedDate = Optional.empty();
            try {
                Method method = license.getClass().getMethod("getExpiryZonedDate", new Class[0]);
                expiryZonedDate = (Optional)method.invoke((Object)license, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            expiryDate = expiryZonedDate.isPresent() ? this.dateFormatter.format(Date.from(((ZonedDateTime)expiryZonedDate.get()).toInstant())) : null;
        }
        return expiryDate;
    }
}

