/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.notifications;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.Interval;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.notifications.EmailNotifier;
import com.enhancera.auditor.common.notifications.Notifications;
import com.enhancera.auditor.common.settings.SettingsService;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class NotificationTask
implements Runnable {
    private final Notifications notifications;
    private final EmailNotifier emailNotifier;
    private final DataLayer dataLayer;
    private final SettingsService settingsService;

    public NotificationTask(Notifications notifications, EmailNotifier emailNotifier, DataLayer dataLayer, SettingsService settingsService) {
        this.notifications = notifications;
        this.emailNotifier = emailNotifier;
        this.dataLayer = dataLayer;
        this.settingsService = settingsService;
    }

    @Override
    public void run() {
        List<User> notifiedUsers = this.settingsService.getSettings().getNotifiedUsers();
        if (notifiedUsers.isEmpty()) {
            return;
        }
        Instant from = Instant.now().minus(Duration.ofDays(1L));
        List<Event> events = this.dataLayer.readEvents(EventCriteria.builder().setInterval(new Interval(from, Instant.now())).build());
        if (!events.isEmpty()) {
            this.emailNotifier.notify(this.notifications.getEventSummaryNotification(events, notifiedUsers));
        }
    }
}

