/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.javax;

import com.enhancera.auditor.common.ResponseData;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.servlet.javax.ContentCopyingServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;

public class StatusExposingServletResponse
extends ContentCopyingServletResponse {
    private static final FormattingLogger log = FormattingLogger.getLogger(StatusExposingServletResponse.class);
    private final List<Pattern> errorPatterns;
    private int httpStatus = 200;

    public StatusExposingServletResponse(HttpServletResponse response, List<Pattern> errorPatterns) {
        super(response);
        this.errorPatterns = errorPatterns;
    }

    public int getStatus() {
        return this.httpStatus;
    }

    private boolean isErrorDetected() {
        String content = this.getContent();
        if (content != null) {
            for (Pattern errorPattern : this.errorPatterns) {
                if (!errorPattern.matcher(content).find()) continue;
                log.debug("Error pattern '%s' matched by output", errorPattern.pattern());
                return true;
            }
        }
        return false;
    }

    public ResponseData getResponseData() {
        return new ResponseData(this.getStatus(), this.isErrorDetected());
    }

    public void sendError(int sc) throws IOException {
        this.httpStatus = sc;
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.httpStatus = sc;
        super.sendError(sc, msg);
    }

    public void sendRedirect(String location) throws IOException {
        this.httpStatus = 302;
        super.sendRedirect(location);
    }

    public void setStatus(int sc) {
        this.httpStatus = sc;
        super.setStatus(sc);
    }

    public void setStatus(int sc, String s2) {
        this.httpStatus = sc;
        super.setStatus(sc, s2);
    }
}

