/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import java.util.ArrayList;
import java.util.List;

public class PrimaryApplicationLinkTransformer
implements Transformer {
    private final ApplicationLinkService applicationLinkService;

    public PrimaryApplicationLinkTransformer(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    @Override
    public List<String> transform(List<String> args) {
        Iterable applicationLinks = this.applicationLinkService.getApplicationLinks();
        ArrayList<String> primaryLinks = new ArrayList<String>();
        for (ApplicationLink applicationLink : applicationLinks) {
            if (!applicationLink.isPrimary()) continue;
            primaryLinks.add(applicationLink.getName());
        }
        return ConvertionUtils.values(primaryLinks);
    }
}

