/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.rest;

import com.atlassian.sal.api.user.UserManager;
import com.enhancera.auditor.common.DataOption;
import com.enhancera.auditor.common.DataOptionType;
import com.enhancera.auditor.common.DataOptionsProvider;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.rest.ServiceResponse;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.UserUtils;
import java.util.Set;

public class FilterDataResourceExecutor {
    private static final FormattingLogger log = FormattingLogger.getLogger(FilterDataResourceExecutor.class);
    private final DataOptionsProvider dataOptionsProvider;
    private final UserUtils userUtils;
    private final UserManager userManager;
    private final SettingsService settingsService;

    public FilterDataResourceExecutor(DataOptionsProvider dataOptionsProvider, UserUtils userUtils, UserManager userManager, SettingsService settingsService) {
        this.dataOptionsProvider = dataOptionsProvider;
        this.userUtils = userUtils;
        this.userManager = userManager;
        this.settingsService = settingsService;
    }

    public ServiceResponse getObjectOptions(DataOptionType option, String param) {
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to view audit trail.", user);
            return ServiceResponse.serverError().status(403).build();
        }
        Set<DataOption> dataOptions = this.dataOptionsProvider.findDataOptions(option, param, false);
        return ServiceResponse.ok(dataOptions).build();
    }
}

