/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.extras.api.ProductLicense;
import com.atlassian.spring.container.ContainerManager;
import com.enhancera.auditor.common.transformers.LicenseDetailsTransformer;
import com.enhancera.auditor.common.util.DateFormatter;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;

public class ConfluenceLicenseDetailsTransformer
extends LicenseDetailsTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfluenceLicenseDetailsTransformer.class);

    public ConfluenceLicenseDetailsTransformer(DateFormatter dateFormatter) {
        super(dateFormatter);
    }

    @Override
    @Nullable
    public ProductLicense getLicense(List<String> args) {
        Object licenseService = ContainerManager.getComponent((String)"licenseService");
        if (licenseService == null) {
            return null;
        }
        try {
            Method getLicenseMethod = licenseService.getClass().getMethod("retrieve", new Class[0]);
            return (ProductLicense)getLicenseMethod.invoke(licenseService, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to get license details due to: ", e);
            return null;
        }
    }
}

