/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Preconditions;
import java.util.List;

public class AnonymousByPermissionAndSpaceTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(AnonymousByPermissionAndSpaceTransformer.class);
    private final SpaceManager spaceManager;
    private final SpacePermissionManager spacePermissionManager;

    public AnonymousByPermissionAndSpaceTransformer(SpaceManager spaceManager, SpacePermissionManager spacePermissionManager) {
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
    }

    @Override
    public String transformSingle(List<String> args) {
        List permissions;
        Preconditions.checkArgument(args.size() == 1 || args.size() == 2);
        String permissionType = args.get(0);
        Space space = null;
        if (args.size() > 1) {
            String spaceKey = args.get(1);
            space = this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                log.debug("Space not found for key %s.", spaceKey);
                return null;
            }
            permissions = space.getPermissions();
        } else {
            permissions = this.spacePermissionManager.getGlobalPermissions(permissionType);
        }
        for (SpacePermission permission : permissions) {
            if (!permissionType.equals(permission.getType()) || !permission.isAnonymousPermission()) continue;
            return "yes";
        }
        return "no";
    }
}

