/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.Severity;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;

public class AuditorSettingsTransformer
implements Transformer {
    private final SettingsService settingsService;

    public AuditorSettingsTransformer(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public List<String> transform(List<String> args) {
        String retentionPeriod;
        Settings settings = this.settingsService.getSettings();
        long retentionPeriodDays = settings.getRetentionPeriod().getStandardDays();
        String string = retentionPeriod = retentionPeriodDays == 0L ? "unlimited" : retentionPeriodDays + " day";
        if (retentionPeriodDays > 1L) {
            retentionPeriod = retentionPeriod + "s";
        }
        return ConvertionUtils.values(retentionPeriod, settings.getNumberOfEventsPerPage(), settings.isSystemAdminAccessOnly(), Joiner.on(", ").join(Lists.transform(settings.getNotifiedUsers(), user -> user.getUsername())), settings.isWriteToFile(), settings.getFilePath(), settings.isWriteToSyslog(), settings.getSyslogHost(), Facility.fromNumericalCode(settings.getSyslogFacility()).label(), Severity.fromNumericalCode(settings.getSyslogLevel()).label());
    }
}

