/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.enhancera.auditor.common.EventTemplate;
import com.enhancera.auditor.common.HostAppService;
import com.enhancera.auditor.common.RequestData;
import com.enhancera.auditor.common.RequestProcessor;
import com.enhancera.auditor.common.RequestType;
import com.enhancera.auditor.common.ResponseData;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.filter.ChainDoFilterException;
import com.enhancera.auditor.common.filter.CompatibilityRequestWrapper;
import com.enhancera.auditor.common.filter.RestReadingServletRequest;
import com.enhancera.auditor.common.filter.StatusExposingServletResponse;
import com.enhancera.auditor.common.filter.WebEventsFilter;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.JsonProxy;
import com.enhancera.auditor.common.util.RequestBody;
import com.enhancera.auditor.common.util.RequestUtils;
import com.enhancera.auditor.common.util.UserUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;

@UnrestrictedAccess
public class RestEventsFilter
implements Filter {
    private static final FormattingLogger log = FormattingLogger.getLogger(RestEventsFilter.class);
    private FilterConfig config;
    private final UserUtils userUtils;
    private final RequestProcessor requestProcessor;

    public RestEventsFilter(UserUtils userUtils, RequestProcessor requestProcessor, HostAppService hostAppService) {
        this.userUtils = userUtils;
        this.requestProcessor = requestProcessor;
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    public void destroy() {
        this.config = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequestWrapper wrappedRequest;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            log.info("Either request or response are non-HTTP.Don't know how to deal with them, so just skipping.", new Object[0]);
            chain.doFilter(request, response);
            return;
        }
        try {
            wrappedRequest = new RestReadingServletRequest((HttpServletRequest)request);
            wrappedRequest = new CompatibilityRequestWrapper((HttpServletRequest)wrappedRequest);
        }
        catch (Exception e) {
            log.error(e);
            chain.doFilter(request, response);
            return;
        }
        try {
            EventTemplate eventTemplate;
            String url = wrappedRequest.getRequestURI();
            String ipAddress = RequestUtils.extractIpAddress((HttpServletRequest)wrappedRequest);
            User author = this.userUtils.getCurrentUser();
            ListMultimap<String, String> requestParameters = RequestUtils.getParametersMultimap((HttpServletRequest)request);
            ListMultimap<String, String> requestHeaders = RequestUtils.getHeadersMultimap((HttpServletRequest)request);
            DateTime time = DateTime.now();
            String method = wrappedRequest.getMethod();
            RestReadingServletRequest restReadingServletRequest = (RestReadingServletRequest)wrappedRequest.getRequest();
            String restBody = restReadingServletRequest.getBody();
            JsonProxy json = new JsonProxy(restBody);
            RequestBody body = new RequestBody(restBody);
            if (json.isEmpty() && !Strings.isNullOrEmpty(restBody)) {
                requestParameters.putAll(RequestUtils.parsePostDataParameters(restBody));
            }
            RequestData requestData = new RequestData(author, ipAddress, time, method, url, requestParameters, requestHeaders, json, body, RequestType.REST);
            try {
                eventTemplate = this.requestProcessor.preprocess(requestData);
            }
            catch (Exception e) {
                log.error(e, "Error occurred preprocessing request data: " + requestData, new Object[0]);
                WebEventsFilter.doFilterInsideTryBlock((ServletRequest)wrappedRequest, response, chain);
                return;
            }
            if (eventTemplate != null) {
                StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response, this.requestProcessor.getErrorPatterns());
                WebEventsFilter.doFilterInsideTryBlock((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse, chain);
                ResponseData responseData = wrappedResponse.getResponseData();
                log.debug("Auditor action: %s, responseData: %s", url, responseData);
                try {
                    this.requestProcessor.postprocess(eventTemplate, requestData, responseData);
                }
                catch (Exception e) {
                    log.error(e, "Error occurred postprocessing request data: " + requestData, new Object[0]);
                }
            } else {
                WebEventsFilter.doFilterInsideTryBlock((ServletRequest)wrappedRequest, response, chain);
            }
        }
        catch (ChainDoFilterException e) {
            try {
                throw (Exception)e.getCause();
            }
            catch (IOException | RuntimeException | ServletException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Exception e) {
            log.error(e, "Error processing REST request", new Object[0]);
            chain.doFilter((ServletRequest)wrappedRequest, response);
        }
    }
}

