/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.enhancera.auditor.common.transformers.ApplicationLinkUpdateParametersByKeyTransformer;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import java.util.List;

public class InAppNotificationSettingsParametersTransformer
implements Transformer {
    private final ApplicationLinkUpdateParametersByKeyTransformer applicationParametersTransformer;

    public InAppNotificationSettingsParametersTransformer(ApplicationLinkUpdateParametersByKeyTransformer applicationParametersTransformer) {
        this.applicationParametersTransformer = applicationParametersTransformer;
    }

    @Override
    public List<String> transform(List<String> args) {
        String type = args.get(0);
        String activePollingInterval = null;
        String inactivePollingInterval = null;
        String applicationName = null;
        String applicationUrl = null;
        switch (type) {
            case "LOCAL": {
                type = "In-app notifications are displayed for this Confluence instance";
                activePollingInterval = args.get(1);
                inactivePollingInterval = args.get(2);
                break;
            }
            case "REMOTE": {
                type = "Notifications from this Confluence server are sent to the remote application";
                List<String> applicationParameters = this.applicationParametersTransformer.transform(args.get(3));
                applicationName = applicationParameters.get(0);
                applicationUrl = applicationParameters.get(2);
                break;
            }
            case "NONE": {
                type = "In-app notifications are disabled on this server";
            }
        }
        return ConvertionUtils.values(type, activePollingInterval, inactivePollingInterval, applicationName, applicationUrl);
    }
}

