/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common;

import com.enhancera.auditor.common.util.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class EventCriteria {
    public static final EventCriteria ALL = EventCriteria.create((String)null);
    @Nullable
    private final String searchQuery;
    @Nullable
    private final Interval interval;
    @Nullable
    private final Set<String> authors;
    @Nullable
    private final Set<String> ips;
    @Nullable
    private final Set<String> categories;
    @Nullable
    private final Set<String> summaries;
    @Nullable
    private final Set<String> objects;
    @Nullable
    private final DateTime time;

    private EventCriteria(Builder builder) {
        this.searchQuery = builder.searchQuery;
        this.interval = builder.interval;
        this.authors = builder.authors;
        this.ips = builder.ips;
        this.categories = builder.categories;
        this.summaries = builder.summaries;
        this.objects = builder.objects;
        this.time = builder.time;
    }

    public static EventCriteria before(DateTime time) {
        return new Builder().setInterval(new Interval(0L, time.getMillis())).build();
    }

    public static EventCriteria create(String searchQuery) {
        return new Builder().setSearchQuery(searchQuery).build();
    }

    public static EventCriteria create(@Nullable String searchQuery, @Nullable Long fromTime, @Nullable Long toTime, @Nullable Iterable<String> users, @Nullable Iterable<String> ips, @Nullable Iterable<String> categories, @Nullable Iterable<String> summaries, @Nullable Iterable<String> objects) {
        Builder builder = new Builder();
        builder.setSearchQuery(searchQuery);
        if (fromTime != null || toTime != null) {
            long from = fromTime == null ? 0L : fromTime;
            long to = toTime == null ? Long.MAX_VALUE : toTime;
            builder.setInterval(new Interval(from, to));
        }
        if (users != null) {
            builder.setAuthors(users);
        }
        if (ips != null) {
            builder.setIps(ips);
        }
        if (categories != null) {
            builder.setCategories(categories);
        }
        if (summaries != null) {
            builder.setSummaries(summaries);
        }
        if (objects != null) {
            builder.setObjects(objects);
        }
        return builder.build();
    }

    public static EventCriteria create(HttpServletRequest request) {
        String query = request.getParameter("query");
        String toTimeString = request.getParameter("toTime");
        Long toTime = toTimeString == null ? null : Long.valueOf(Long.parseLong(toTimeString));
        String fromTimeString = request.getParameter("fromTime");
        Long fromTime = fromTimeString == null ? null : Long.valueOf(Long.parseLong(fromTimeString));
        String[] usersArray = request.getParameterValues("users");
        List<String> users = usersArray == null ? null : Arrays.asList(usersArray);
        String[] ipsArray = request.getParameterValues("ips");
        List<String> ips = ipsArray == null ? null : Arrays.asList(ipsArray);
        String[] categoriesArray = request.getParameterValues("categories");
        List<String> categories = categoriesArray == null ? null : Arrays.asList(categoriesArray);
        String[] summariesArray = request.getParameterValues("summaries");
        List<String> summaries = summariesArray == null ? null : Arrays.asList(summariesArray);
        String[] objectsArray = request.getParameterValues("objects");
        List<String> objects = objectsArray == null ? null : Arrays.asList(objectsArray);
        return EventCriteria.create(query, fromTime, toTime, users, ips, categories, summaries, objects);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return !(this.searchQuery != null && !this.searchQuery.isEmpty() || this.authors != null && !this.authors.isEmpty() || this.ips != null && !this.ips.isEmpty() || this.categories != null && !this.categories.isEmpty() || this.summaries != null && !this.summaries.isEmpty() || this.objects != null && !this.objects.isEmpty() || this.interval != null || this.time != null);
    }

    @Nullable
    public String getSearchQuery() {
        return this.searchQuery;
    }

    @Nullable
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    public Set<String> getAuthors() {
        return this.authors;
    }

    @Nullable
    public Set<String> getIpAddresses() {
        return this.ips;
    }

    @Nullable
    public Set<String> getCategories() {
        return this.categories;
    }

    @Nullable
    public Set<String> getSummaries() {
        return this.summaries;
    }

    @Nullable
    public Set<String> getObjects() {
        return this.objects;
    }

    @Nullable
    public DateTime getTime() {
        return this.time;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("searchQuery", this.searchQuery).add("interval", this.interval).add("time", this.time).add("categories", this.categories).add("summaries", this.summaries).add("objects", this.objects).add("authors", this.authors).add("ips", this.ips).toString();
    }

    public static class Builder {
        private String searchQuery;
        private Interval interval;
        private Set<String> categories;
        private Set<String> summaries;
        private Set<String> objects;
        private DateTime time;
        private Set<String> authors;
        private Set<String> ips;

        public Builder setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public Builder setInterval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder setAuthors(Iterable<String> authors) {
            this.authors = ImmutableSet.copyOf(authors);
            return this;
        }

        public Builder setIps(Iterable<String> ips) {
            this.ips = ImmutableSet.copyOf(ips);
            return this;
        }

        public Builder setCategories(Iterable<String> categories) {
            this.categories = ImmutableSet.copyOf(categories);
            return this;
        }

        public Builder setSummaries(Iterable<String> summaries) {
            this.summaries = ImmutableSet.copyOf(summaries);
            return this;
        }

        public Builder setObjects(Iterable<String> objects) {
            this.objects = ImmutableSet.copyOf(objects);
            return this;
        }

        public Builder setTime(DateTime time) {
            this.time = time;
            return this;
        }

        public EventCriteria build() {
            return new EventCriteria(this);
        }
    }
}

