/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.enhancera.auditor.common.transformers.ApplicationLinkNameByKeyTransformer;
import com.enhancera.auditor.common.transformers.WhitelistParametersByIdTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import java.util.List;

public class WhitelistExpressionByIdTransformer
extends WhitelistParametersByIdTransformer {
    private final ApplicationLinkNameByKeyTransformer applicationLinkNameByKeyTransformer;

    public WhitelistExpressionByIdTransformer(WhitelistService whitelistService, ApplicationLinkNameByKeyTransformer applicationLinkNameByKeyTransformer) {
        super(whitelistService);
        this.applicationLinkNameByKeyTransformer = applicationLinkNameByKeyTransformer;
    }

    @Override
    public String parametersName() {
        return "expression";
    }

    @Override
    public List<String> parametersValue(WhitelistRule whitelist) {
        String name;
        String expression = whitelist.getExpression();
        if (whitelist.getType() == WhitelistType.APPLICATION_LINK && (name = this.applicationLinkNameByKeyTransformer.transform(expression).get(0)) != null) {
            expression = name;
        }
        return ConvertionUtils.values(expression);
    }
}

