/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.util.List;

public abstract class ApplicationLinkParametersByKeyTransformer
extends SingleArgumentTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(ApplicationLinkParametersByKeyTransformer.class);
    private final ApplicationLinkService applicationLinkService;

    public abstract List<String> getParameters(ApplicationLink var1);

    public ApplicationLinkParametersByKeyTransformer(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    @Override
    public List<String> transform(String arg) {
        try {
            ApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(new ApplicationId(arg));
            return applicationLink == null ? this.returnIfNull() : this.getParameters(applicationLink);
        }
        catch (TypeNotInstalledException e) {
            log.error(e, "Error getting application link parameters by key: " + arg, new Object[0]);
            return this.returnIfNull();
        }
    }
}

