/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.renderer.UserMacroConfig;
import com.atlassian.confluence.renderer.UserMacroLibrary;
import com.atlassian.spring.container.ContainerManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class UserMacroDetailsByNameTransformer
implements Transformer {
    private static final Map<String, String> BODY_TYPES = ImmutableMap.of("none", "No macro body", "escapehtml", "Escaped", "raw", "Unrendered", "rendered", "Rendered");
    private UserMacroLibrary userMacroLibrary;

    @Override
    public List<String> transform(List<String> args) {
        this.loadUserMacroLibraryComponent();
        UserMacroConfig macro = this.userMacroLibrary.getMacro(args.get(0));
        if (macro == null && (macro = this.userMacroLibrary.getMacro(args.get(1))) == null) {
            return this.returnIfNull();
        }
        return ConvertionUtils.values(macro.getName(), !macro.isHidden(), macro.getTitle(), macro.getDescription(), macro.getCategories(), macro.getIconLocation(), macro.getDocumentationUrl(), UserMacroDetailsByNameTransformer.prettifyBodyType(macro.getBodyType()), macro.getTemplate());
    }

    private void loadUserMacroLibraryComponent() {
        if (this.userMacroLibrary == null) {
            this.userMacroLibrary = (UserMacroLibrary)ContainerManager.getComponent((String)"userMacroLibrary");
        }
    }

    private static String prettifyBodyType(String bodyType) {
        return BODY_TYPES.getOrDefault(bodyType, bodyType);
    }

    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(9);
    }
}

