/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence;

import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.spring.container.ContainerManager;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.util.Optional;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationContext;

public class OsgiUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(OsgiUtils.class);

    private OsgiUtils() {
    }

    public static Optional<ApplicationContext> getAppCtx(String packageName) {
        OsgiContainerManager osgi = (OsgiContainerManager)ContainerManager.getComponent((String)"osgiContainerManager");
        if (osgi == null) {
            log.error("OSGI Not Found", new Object[0]);
            return Optional.empty();
        }
        Bundle[] bundles = osgi.getBundles();
        if (bundles == null) {
            log.error(packageName + " : osgi.getBundles returns null", new Object[0]);
            return Optional.empty();
        }
        for (Bundle bundle : bundles) {
            ServiceReference[] serviceReferences;
            if (bundle == null || !packageName.equals(bundle.getSymbolicName())) continue;
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                log.error(packageName + " : bundleContext is null", new Object[0]);
                return Optional.empty();
            }
            try {
                serviceReferences = bundleContext.getAllServiceReferences(ApplicationContext.class.getName(), null);
            }
            catch (InvalidSyntaxException e) {
                log.error(e, "Can't get application context.", new Object[0]);
                return Optional.empty();
            }
            if (serviceReferences == null) {
                log.error(packageName + " : bundleContext.getAllServiceReferences returns null", new Object[0]);
                return Optional.empty();
            }
            for (ServiceReference serviceReference : serviceReferences) {
                Object serviceNameProperty;
                if (serviceReference == null || !packageName.equals(serviceNameProperty = serviceReference.getProperty("org.springframework.context.service.name"))) continue;
                Object service = bundleContext.getService(serviceReference);
                if (service == null) {
                    log.error(packageName + " : bundleContext.getService returns null", new Object[0]);
                    return Optional.empty();
                }
                return Optional.of((ApplicationContext)service);
            }
        }
        return Optional.empty();
    }
}

