/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.util;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventDetail;
import com.enhancera.auditor.common.EventStorage;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.joda.time.DateTime;

public class FileEventStorage
implements EventStorage {
    private static final FormattingLogger log = FormattingLogger.getLogger(FileEventStorage.class);
    private Path path;

    public FileEventStorage(Path path) {
        this.path = path;
    }

    @Override
    public void storeEvent(Event event) {
        this.clean();
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                Files.createFile(this.path, new FileAttribute[0]);
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.path.toFile()));){
                oos.writeObject(new SerializableEvent(event));
            }
        }
        catch (IOException e) {
            log.error(e, "Error writing event to the file: ", this.path);
        }
    }

    @Override
    public Event restoreEvent() {
        Event event = null;
        if (Files.exists(this.path, new LinkOption[0])) {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.path.toFile()));){
                event = ((SerializableEvent)ois.readObject()).toEvent();
            }
            catch (IOException | ClassNotFoundException e) {
                log.error(e, "Error reading event from the file: ", this.path);
                this.clean();
            }
        }
        return event;
    }

    @Override
    public void clean() {
        try {
            Files.deleteIfExists(this.path);
        }
        catch (IOException e) {
            log.error(e, "Error deleting event file: ", this.path);
        }
    }

    private static class SerializableEvent
    implements Serializable {
        private final String author;
        private final String ipAddress;
        private final long time;
        private final String category;
        private final String summary;
        private final String object;
        private final List<EventDetail> details;

        SerializableEvent(Event event) {
            this.author = event.getAuthor();
            this.ipAddress = event.getIpAddress();
            this.time = event.getTime().getMillis();
            this.category = event.getCategory();
            this.summary = event.getSummary();
            this.object = event.getObject();
            this.details = event.getDetails();
        }

        Event toEvent() {
            return new Event(this.author, this.ipAddress, new DateTime(this.time), this.category, this.summary, this.object, this.details);
        }
    }
}

