/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.plugins.custom_apps.api.CustomApp;
import com.atlassian.plugins.custom_apps.api.CustomAppService;
import com.enhancera.auditor.common.transformers.GenericObjectParametersByIdTransformer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ApplicationNavigationLinkParametersByIdTransformer
extends GenericObjectParametersByIdTransformer<CustomApp> {
    private final CustomAppService customAppService;

    public ApplicationNavigationLinkParametersByIdTransformer(CustomAppService customAppService) {
        this.customAppService = customAppService;
    }

    @Override
    public List<String> transform(String arg) {
        String id = arg;
        Pattern linkPattern = Pattern.compile("/rest/custom-apps/.+/customapps/(\\d+)");
        Matcher m4 = linkPattern.matcher(arg);
        if (m4.matches()) {
            id = m4.group(1);
        }
        return super.transform(id);
    }

    @Override
    public String objectName() {
        return "Application navigation link";
    }

    @Override
    public CustomApp objectValue(long id) throws Exception {
        return this.customAppService.get(String.valueOf(id));
    }
}

