/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.settings;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.Severity;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.UserImpl;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Duration;

public class PersistentSettingsServiceImpl
extends SettingsService {
    private static final FormattingLogger log = FormattingLogger.getLogger(PersistentSettingsServiceImpl.class);
    private static final String RETENTION_PERIOD_PARAM = "retentionPeriod";
    private static final String NUMBER_OF_EVENTS_PER_PAGE_PARAM = "numberOfEventsPerPage";
    private static final String SYSTEM_ADMIN_ACCESS_ONLY = "systemAdminAccessOnly";
    private static final String NOTIFIED_USERS = "notifiedUsers";
    private static final String WRITE_TO_SYSLOG = "writeToSyslog";
    private static final String SYSLOG_HOST = "syslogHost";
    private static final String SYSLOG_FACILITY = "syslogFacility";
    private static final String SYSLOG_LEVEL = "syslogLevel";
    private static final String WRITE_TO_FILE = "writeToFile";
    private static final String FILE_PATH = "filePath";
    public static final ImmutableMap<Integer, Integer> OLD_TO_NEW_SEVERITY_MAP = ImmutableMap.builder().put(10000, Severity.DEBUG.numericalCode()).put(20000, Severity.INFORMATIONAL.numericalCode()).put(30000, Severity.WARNING.numericalCode()).put(40000, Severity.ERROR.numericalCode()).put(50000, Severity.EMERGENCY.numericalCode()).build();
    private static final ImmutableMap<Integer, Integer> OLD_TO_NEW_FACILITY_MAP = ImmutableMap.builder().put(0, Facility.KERN.numericalCode()).put(8, Facility.USER.numericalCode()).put(16, Facility.MAIL.numericalCode()).put(24, Facility.DAEMON.numericalCode()).put(32, Facility.AUTH.numericalCode()).put(40, Facility.SYSLOG.numericalCode()).put(48, Facility.LPR.numericalCode()).put(56, Facility.NEWS.numericalCode()).put(64, Facility.UUCP.numericalCode()).put(72, Facility.CRON.numericalCode()).put(80, Facility.AUTHPRIV.numericalCode()).put(88, Facility.FTP.numericalCode()).put(128, Facility.LOCAL0.numericalCode()).put(136, Facility.LOCAL1.numericalCode()).put(144, Facility.LOCAL2.numericalCode()).put(152, Facility.LOCAL3.numericalCode()).put(160, Facility.LOCAL4.numericalCode()).put(168, Facility.LOCAL5.numericalCode()).put(176, Facility.LOCAL6.numericalCode()).put(184, Facility.LOCAL7.numericalCode()).build();
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;

    public PersistentSettingsServiceImpl(PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public Settings getSettings() {
        return (Settings)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Settings>(){

            public Settings doInTransaction() {
                String filePathString;
                String writeToFileString;
                String syslogHostString;
                String writeToSyslogString;
                List notifiedUsersStrings;
                String systemAdminAccessOnlyString;
                String numberOfEventsPerPageString;
                PluginSettings pluginSettings = PersistentSettingsServiceImpl.this.pluginSettingsFactory.createGlobalSettings();
                Settings settings = new Settings();
                String retentionPeriodString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.RETENTION_PERIOD_PARAM));
                if (retentionPeriodString != null) {
                    settings.setRetentionPeriod(Duration.parse(retentionPeriodString));
                }
                if ((numberOfEventsPerPageString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.NUMBER_OF_EVENTS_PER_PAGE_PARAM))) != null) {
                    settings.setNumberOfEventsPerPage(Integer.parseInt(numberOfEventsPerPageString));
                }
                if ((systemAdminAccessOnlyString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSTEM_ADMIN_ACCESS_ONLY))) != null) {
                    settings.setSystemAdminAccessOnly(Boolean.valueOf(systemAdminAccessOnlyString));
                }
                if ((notifiedUsersStrings = (List)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.NOTIFIED_USERS))) != null) {
                    settings.setNotifiedUsers(Lists.transform(notifiedUsersStrings, new Function<String, User>(){

                        @Override
                        public User apply(String s2) {
                            return PersistentSettingsServiceImpl.this.userFromString(s2);
                        }
                    }));
                }
                if ((writeToSyslogString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.WRITE_TO_SYSLOG))) != null) {
                    settings.setWriteToSyslog(Boolean.valueOf(writeToSyslogString));
                }
                if ((syslogHostString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_HOST))) != null) {
                    settings.setSyslogHost(syslogHostString);
                }
                String syslogFacilityString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_FACILITY));
                String syslogLevelString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_LEVEL));
                if (syslogLevelString != null) {
                    int syslogLevel = Integer.parseInt(syslogLevelString);
                    if (OLD_TO_NEW_SEVERITY_MAP.containsKey(syslogLevel)) {
                        syslogLevel = OLD_TO_NEW_SEVERITY_MAP.get(syslogLevel);
                        pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_LEVEL), (Object)String.valueOf(syslogLevel));
                        if (syslogFacilityString != null) {
                            int syslogFacility = Integer.parseInt(syslogFacilityString);
                            if (OLD_TO_NEW_FACILITY_MAP.containsKey(syslogFacility)) {
                                syslogFacility = (Integer)OLD_TO_NEW_FACILITY_MAP.get(syslogFacility);
                                syslogFacilityString = String.valueOf(syslogFacility);
                                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_FACILITY), (Object)syslogFacilityString);
                            }
                        }
                    }
                    settings.setSyslogLevel(syslogLevel);
                }
                if (syslogFacilityString != null) {
                    settings.setSyslogFacility(Integer.parseInt(syslogFacilityString));
                }
                if ((writeToFileString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.WRITE_TO_FILE))) != null) {
                    settings.setWriteToFile(Boolean.valueOf(writeToFileString));
                }
                if ((filePathString = (String)pluginSettings.get(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.FILE_PATH))) != null) {
                    settings.setFilePath(filePathString);
                }
                return settings;
            }
        });
    }

    @Override
    public void setSettings(final Settings settings) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                PluginSettings pluginSettings = PersistentSettingsServiceImpl.this.pluginSettingsFactory.createGlobalSettings();
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.RETENTION_PERIOD_PARAM), (Object)settings.getRetentionPeriod().toString());
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.NUMBER_OF_EVENTS_PER_PAGE_PARAM), (Object)String.valueOf(settings.getNumberOfEventsPerPage()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSTEM_ADMIN_ACCESS_ONLY), (Object)String.valueOf(settings.isSystemAdminAccessOnly()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.NOTIFIED_USERS), new ArrayList<String>(Lists.transform(settings.getNotifiedUsers(), new Function<User, String>(){

                    @Override
                    public String apply(User user) {
                        return PersistentSettingsServiceImpl.this.userToString(user);
                    }
                })));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.WRITE_TO_SYSLOG), (Object)String.valueOf(settings.isWriteToSyslog()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_HOST), (Object)String.valueOf(settings.getSyslogHost()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_FACILITY), (Object)String.valueOf(settings.getSyslogFacility()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.SYSLOG_LEVEL), (Object)String.valueOf(settings.getSyslogLevel()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.WRITE_TO_FILE), (Object)String.valueOf(settings.isWriteToFile()));
                pluginSettings.put(PersistentSettingsServiceImpl.getParameterKey(PersistentSettingsServiceImpl.FILE_PATH), (Object)String.valueOf(settings.getFilePath()));
                return null;
            }
        });
        this.setChanged();
        this.notifyObservers();
    }

    private String userToString(User user) {
        String fullName = user.getFullName() == null ? "" : user.getFullName();
        String email = user.getEmail() == null ? "" : user.getEmail();
        return String.format("username:%s&fullName:%s&email:%s", user.getUsername(), fullName, email);
    }

    private User userFromString(String s2) {
        Matcher m4 = Pattern.compile("username:(.*)&fullName:(.+)?&email:(.+)?").matcher(s2);
        if (m4.matches()) {
            return new UserImpl(m4.group(1), m4.group(2), m4.group(3));
        }
        log.error("Error reading stored user: " + s2, new Object[0]);
        return null;
    }

    private static final String getParameterKey(String param) {
        return Settings.class.getName() + "." + param;
    }
}

