/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.logwriters;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.logwriters.AuditLogWriter;
import com.enhancera.auditor.common.logwriters.LogWriterFormattingUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingAuditLogWriter
implements AuditLogWriter {
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private String category;

    public LoggingAuditLogWriter(String category) {
        this.category = category;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void write(Event event) {
        this.getLogger().log((Priority)this.getLevel(), (Object)LogWriterFormattingUtils.formatEvent(event));
    }

    public Logger getLogger() {
        Logger logger = Logger.getLogger((String)this.category);
        logger.setLevel(this.getLevel());
        return logger;
    }

    public Level getLevel() {
        return DEFAULT_LEVEL;
    }

    @Override
    public void clear() {
        this.getLogger().log((Priority)this.getLevel(), (Object)"Event log cleared");
    }
}

