/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class FormattingLogger {
    private Logger logger;

    private FormattingLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static final FormattingLogger getLogger(Class<?> cls) {
        return new FormattingLogger(Logger.getLogger(cls));
    }

    public static final FormattingLogger getLogger(String name) {
        return new FormattingLogger(Logger.getLogger((String)name));
    }

    public void debug(String message, Object ... args) {
        this.log(Level.DEBUG, message, args);
    }

    public void debug(Throwable t2, String message, Object ... args) {
        this.log(Level.DEBUG, t2, message, args);
    }

    public void info(String message, Object ... args) {
        this.log(Level.INFO, message, args);
    }

    public void info(Throwable t2, String message, Object ... args) {
        this.log(Level.INFO, t2, message, args);
    }

    public void warn(String message, Object ... args) {
        this.log(Level.WARN, message, args);
    }

    public void warn(Throwable t2, String message, Object ... args) {
        this.log(Level.WARN, t2, message, args);
    }

    public void error(Throwable t2) {
        this.log(Level.ERROR, t2, t2.getMessage(), new Object[0]);
    }

    public void error(String message, Object ... args) {
        this.log(Level.ERROR, message, args);
    }

    public void error(Throwable t2, String message, Object ... args) {
        this.log(Level.ERROR, t2, message, args);
    }

    public void fatal(String message, Object ... args) {
        this.log(Level.FATAL, message, args);
    }

    public void fatal(Throwable t2, String message, Object ... args) {
        this.log(Level.FATAL, t2, message, args);
    }

    public void log(Level level, String message, Object ... args) {
        if (this.logger.isEnabledFor((Priority)level)) {
            if (args.length > 0) {
                message = String.format(message, args);
            }
            this.logger.log((Priority)level, (Object)message);
        }
    }

    public void log(Level level, Throwable t2, String message, Object ... args) {
        if (this.logger.isEnabledFor((Priority)level)) {
            if (args.length > 0) {
                message = String.format(message, args);
            }
            this.logger.log((Priority)level, (Object)message, t2);
        }
    }
}

