/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.spring.container.ContainerManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.util.List;

public class TrashContentParametersByIdTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(TrashContentParametersByIdTransformer.class);

    @Override
    public List<String> transform(List<String> args) {
        ContentEntityManager contentEntityManager = (ContentEntityManager)ContainerManager.getComponent((String)"contentEntityManager");
        String spaceKey = args.get(0);
        long id = Long.parseLong(args.get(1));
        String type = null;
        String title = null;
        ContentEntityObject entityObject = contentEntityManager.getById(id);
        if (entityObject == null) {
            return this.returnIfNull();
        }
        if (entityObject instanceof Page) {
            Page page = (Page)entityObject;
            if (page.isDeleted() && page.getSpaceKey().equals(spaceKey)) {
                type = "Page";
                title = page.getTitle();
            }
        } else if (entityObject instanceof BlogPost) {
            BlogPost blogPost = (BlogPost)entityObject;
            if (blogPost.isDeleted() && blogPost.getSpaceKey().equals(spaceKey)) {
                type = "Blog post";
                title = blogPost.getTitle();
            }
        } else if (entityObject instanceof Attachment) {
            Attachment attachment = (Attachment)entityObject;
            Space space = attachment.getSpace();
            if (attachment.isDeleted() && space != null && space.getKey().equals(spaceKey)) {
                type = "Attachment";
                title = attachment.getTitle();
            }
        } else {
            log.error("Error obtaining trash content by parameters: " + args, new Object[0]);
        }
        return ConvertionUtils.values(type, title);
    }

    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(2);
    }
}

