/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.primitives.Longs;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PageDetailsByFeedbackReportFileNameTransformer
extends SingleArgumentTransformer {
    private static final Pattern PAGE_ID_IN_FILENAME_PATTERN = Pattern.compile("collab_data_(\\d+)_(\\d+).zip");
    private final PageManager pageManager;

    public PageDetailsByFeedbackReportFileNameTransformer(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @Override
    public List<String> transform(String arg) {
        Matcher matcher = PAGE_ID_IN_FILENAME_PATTERN.matcher(arg);
        if (!matcher.find()) {
            return this.returnIfNull();
        }
        Long pageId = Longs.tryParse(matcher.group(1));
        if (pageId == null) {
            return this.returnIfNull();
        }
        Page page = this.pageManager.getPage(pageId.longValue());
        if (page == null) {
            return this.returnIfNull();
        }
        Long timeMillis = Longs.tryParse(matcher.group(2));
        if (timeMillis == null) {
            return ConvertionUtils.values(pageId, page.getTitle(), null);
        }
        Date date = new Date(timeMillis);
        String formattedDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(date);
        return ConvertionUtils.values(pageId, page.getTitle(), formattedDate);
    }

    @Override
    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(3);
    }
}

