/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.jmx.JmxSMTPMailServer;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.spring.container.ContainerManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.StringMaskingUtils;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.List;

public class MailServerDetailsByIdTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(MailServerDetailsByIdTransformer.class);

    @Override
    public List<String> transform(List<String> args) {
        Preconditions.checkArgument(args.size() == 1);
        MailServerManager mailServerManager = (MailServerManager)ContainerManager.getComponent((String)"mailServerManager");
        String stringId = args.get(0);
        try {
            Long id = Long.parseLong(stringId);
            MailServer mailServer = mailServerManager.getMailServer(id);
            if (mailServer == null) {
                log.debug("Mail server not found for id %s.", id);
                return ConvertionUtils.nullValues(12);
            }
            if (mailServer.getMailProtocol() == MailProtocol.SMTP) {
                return this.getSmtpValues((JmxSMTPMailServer)mailServer);
            }
            return this.getPopValues(mailServer);
        }
        catch (Exception e) {
            log.error("Error getting mail server by id %s: %s", stringId, e);
            return ConvertionUtils.nullValues(12);
        }
    }

    private List<String> getPopValues(MailServer mailServer) {
        String toAddress;
        try {
            Field field = mailServer.getClass().getDeclaredField("toAddress");
            field.setAccessible(true);
            toAddress = (String)field.get(mailServer);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            toAddress = "<None>";
        }
        return ConvertionUtils.values(mailServer.getName(), null, null, toAddress, null, mailServer.getHostname(), mailServer.getPort(), null, null, mailServer.getUsername(), StringMaskingUtils.mask(mailServer.getPassword()), mailServer.getMailProtocol());
    }

    private List<String> getSmtpValues(JmxSMTPMailServer mailServer) {
        return ConvertionUtils.values(mailServer.getName(), mailServer.getDefaultFrom(), mailServer.getFromName(), null, mailServer.getPrefix(), mailServer.getHostname(), mailServer.getPort(), mailServer.isTlsRequired(), mailServer.getJndiLocation(), mailServer.getUsername(), StringMaskingUtils.mask(mailServer.getPassword()), mailServer.getMailProtocol());
    }
}

