/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.confluence.transformers.PageParametersByIdTransformer;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;

public class PagePermissionsByIdTransformer
extends PageParametersByIdTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(PagePermissionsByIdTransformer.class);
    private final ContentPermissionManager contentPermissionManager;

    public PagePermissionsByIdTransformer(ContentPermissionManager contentPermissionManager, PageManager pageManager) {
        super(pageManager);
        this.contentPermissionManager = contentPermissionManager;
    }

    @Override
    public String parametersName() {
        return "permissions";
    }

    @Override
    public List<String> parametersValue(Page page) {
        List viewPermissions = this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)page, "View");
        List editPermissions = this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)page, "Edit");
        ArrayList<String> groupsThatCanView = new ArrayList<String>();
        ArrayList usersThatCanView = new ArrayList();
        ArrayList<String> groupsThatCanEdit = new ArrayList<String>();
        ArrayList usersThatCanEdit = new ArrayList();
        for (ContentPermissionSet contentPermissions : viewPermissions) {
            groupsThatCanView.addAll(contentPermissions.getGroupNames());
            usersThatCanView.addAll(contentPermissions.getUserNames());
        }
        for (ContentPermissionSet contentPermissions : editPermissions) {
            groupsThatCanEdit.addAll(contentPermissions.getGroupNames());
            usersThatCanEdit.addAll(contentPermissions.getUserNames());
        }
        if (groupsThatCanView.isEmpty() && usersThatCanView.isEmpty()) {
            groupsThatCanView.add("Everyone");
        }
        if (groupsThatCanEdit.isEmpty() && usersThatCanEdit.isEmpty()) {
            groupsThatCanEdit.add("Everyone");
        }
        return ConvertionUtils.values(Joiner.on(", ").join(groupsThatCanView), Joiner.on(", ").join(usersThatCanView), Joiner.on(", ").join(groupsThatCanEdit), Joiner.on(", ").join(usersThatCanEdit));
    }

    @Override
    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(4);
    }
}

