/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.database;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.enhancera.auditor.common.DataOption;
import com.enhancera.auditor.common.DataOptionType;
import com.enhancera.auditor.common.DataOptionsProvider;
import com.enhancera.auditor.common.ao.EventEntity;
import com.enhancera.auditor.common.database.EntityPropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;
import net.java.ao.Query;
import net.java.ao.db.PostgreSQLDatabaseProvider;

public class DatabaseDataOptionsProvider
implements DataOptionsProvider {
    private static final int MAX_DATA_OPTIONS_COUNT = 1000;
    private final ActiveObjects ao;

    public DatabaseDataOptionsProvider(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Set<DataOption> findDataOptions(DataOptionType type, String text, boolean exactMatch) {
        EntityPropertyDescriptor<String, EventEntity> descriptor;
        switch (type) {
            case AUTHOR: {
                descriptor = new EntityPropertyDescriptor<String, EventEntity>(){

                    @Override
                    public String propertyName() {
                        return "AUTHOR";
                    }

                    @Override
                    public String getProperty(EventEntity event) {
                        return event.getAuthor();
                    }
                };
                break;
            }
            case IP: {
                descriptor = new EntityPropertyDescriptor<String, EventEntity>(){

                    @Override
                    public String propertyName() {
                        return "IP_ADDRESS";
                    }

                    @Override
                    public String getProperty(EventEntity event) {
                        return event.getIpAddress();
                    }
                };
                break;
            }
            case CATEGORY: {
                descriptor = new EntityPropertyDescriptor<String, EventEntity>(){

                    @Override
                    public String propertyName() {
                        return "CATEGORY";
                    }

                    @Override
                    public String getProperty(EventEntity event) {
                        return event.getCategory();
                    }
                };
                break;
            }
            case SUMMARY: {
                descriptor = new EntityPropertyDescriptor<String, EventEntity>(){

                    @Override
                    public String propertyName() {
                        return "SUMMARY";
                    }

                    @Override
                    public String getProperty(EventEntity event) {
                        return event.getSummary();
                    }
                };
                break;
            }
            case OBJECT: {
                descriptor = new EntityPropertyDescriptor<String, EventEntity>(){

                    @Override
                    public String propertyName() {
                        return "OBJECT";
                    }

                    @Override
                    public String getProperty(EventEntity event) {
                        return event.getObject();
                    }
                };
                break;
            }
            default: {
                throw new IllegalStateException("Data options search is not implemented for type " + (Object)((Object)type));
            }
        }
        return this.getEventFieldOptions(descriptor, text, exactMatch);
    }

    private Set<DataOption> getEventFieldOptions(EntityPropertyDescriptor<String, EventEntity> descriptor, String param, boolean exactMatch) {
        HashSet<DataOption> values;
        block5: {
            int count;
            String tableName;
            DatabaseProvider databaseProvider;
            String propertyName;
            block6: {
                values = new HashSet<DataOption>();
                propertyName = descriptor.propertyName();
                if (this.ao.count(EventEntity.class) <= 0) break block5;
                EntityManager entityManager = ((EventEntity[])this.ao.find(EventEntity.class, Query.select().limit(1)))[0].getEntityManager();
                databaseProvider = entityManager.getProvider();
                tableName = entityManager.getTableNameConverter().getName(EventEntity.class);
                count = 0;
                if (!exactMatch) break block6;
                String query = databaseProvider instanceof PostgreSQLDatabaseProvider ? "SELECT MAX(\"ID\") AS ID FROM \"%1$s\" WHERE \"%2$s\" LIKE '%3$s%%' GROUP BY \"%2$s\"" : "SELECT MAX(ID) AS ID FROM %1$s WHERE %2$s = '%3$s' GROUP BY %2$s";
                for (EventEntity entity : (EventEntity[])this.ao.findWithSQL(EventEntity.class, "ID", String.format(query, tableName, propertyName, param), new Object[0])) {
                    if (count++ < 1000) {
                        values.add(new DataOption(entity.getID(), descriptor.getProperty(entity)));
                        continue;
                    }
                    break block5;
                }
                break block5;
            }
            param = param.toUpperCase();
            String query = databaseProvider instanceof PostgreSQLDatabaseProvider ? "SELECT MAX(\"ID\") AS ID FROM \"%1$s\" WHERE UPPER(\"%2$s\") LIKE '%3$s%%' GROUP BY \"%2$s\"" : "SELECT MAX(ID) AS ID FROM %1$s WHERE UPPER(%2$s) LIKE '%3$s%%' GROUP BY %2$s";
            for (EventEntity entity : (EventEntity[])this.ao.findWithSQL(EventEntity.class, "ID", String.format(query, tableName, propertyName, param), new Object[0])) {
                if (count++ >= 1000) break;
                values.add(new DataOption(entity.getID(), descriptor.getProperty(entity)));
            }
            if (!values.isEmpty()) break block5;
            query = databaseProvider instanceof PostgreSQLDatabaseProvider ? "SELECT MAX(\"ID\") AS ID FROM \"%1$s\" WHERE UPPER(\"%2$s\") LIKE '%%%3$s%%' GROUP BY \"%2$s\"" : "SELECT MAX(ID) AS ID FROM %1$s WHERE UPPER(%2$s) LIKE '%%%3$s%%' GROUP BY %2$s";
            for (EventEntity entity : (EventEntity[])this.ao.findWithSQL(EventEntity.class, "ID", String.format(query, tableName, propertyName, param), new Object[0])) {
                if (count++ < 1000) {
                    values.add(new DataOption(entity.getID(), descriptor.getProperty(entity)));
                    continue;
                }
                break;
            }
        }
        return values;
    }
}

