/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.enhancera.auditor.common.transformers.WhitelistExpressionByIdTransformer;
import com.enhancera.auditor.common.transformers.WhitelistParametersByIdTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class WhitelistUpdateParametersByIdTransformer
extends WhitelistParametersByIdTransformer {
    private final WhitelistExpressionByIdTransformer expressionByIdTransformer;
    private static final Map<WhitelistType, String> whitelistTypes = ImmutableMap.of(WhitelistType.APPLICATION_LINK, "Application link", WhitelistType.DOMAIN_NAME, "Domain name", WhitelistType.EXACT_URL, "Exact match", WhitelistType.WILDCARD_EXPRESSION, "Wildcard expression", WhitelistType.REGULAR_EXPRESSION, "Regular expression");

    public WhitelistUpdateParametersByIdTransformer(WhitelistService whitelistService, WhitelistExpressionByIdTransformer expressionByIdTransformer) {
        super(whitelistService);
        this.expressionByIdTransformer = expressionByIdTransformer;
    }

    @Override
    public String parametersName() {
        return "update parameters";
    }

    @Override
    public List<String> parametersValue(WhitelistRule whitelist) {
        List<String> expressionList = this.expressionByIdTransformer.parametersValue(whitelist);
        String expression = expressionList.isEmpty() ? null : expressionList.get(0);
        return ConvertionUtils.values(expression, whitelistTypes.get(whitelist.getType()), whitelist.isAllowInbound(), !whitelist.isAuthenticationRequired());
    }

    @Override
    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(4);
    }
}

