/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.trail;

import au.com.bytecode.opencsv.CSVWriter;
import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.EventDetail;
import com.enhancera.auditor.common.HostAppService;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.LicenseCheckResult;
import com.enhancera.auditor.common.util.LicenseChecker;
import com.enhancera.auditor.common.util.RequestUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@AdminOnly
public class CsvExportServlet
extends HttpServlet {
    private static final long serialVersionUID = -8150306597151068772L;
    private static final FormattingLogger log = FormattingLogger.getLogger(CsvExportServlet.class);
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final DataLayer dataLayer;
    private final PluginLicenseManager pluginLicenseManager;
    private final LicenseChecker licenseChecker;
    private final SettingsService settingsService;
    private final HostAppService hostAppService;

    public CsvExportServlet(UserManager userManager, LoginUriProvider loginUriProvider, DataLayer dataLayer, PluginLicenseManager pluginLicenseManager, LicenseChecker licenseChecker, SettingsService settingsService, HostAppService hostAppService) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.dataLayer = dataLayer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseChecker = licenseChecker;
        this.settingsService = settingsService;
        this.hostAppService = hostAppService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = this.userManager.getRemoteUsername(request);
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            RequestUtils.redirectToLogin(request, response, this.loginUriProvider);
            return;
        }
        EventCriteria criteria = EventCriteria.create(request);
        log.debug("CSV export servlet called for query '%s'", criteria);
        response.setContentType("text/csv;charset=UTF-8");
        String application = this.hostAppService.getApplicationName();
        String date = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        String filename = String.format("%s-audit-log-%s.csv", application, date);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        PrintWriter printWriter = response.getWriter();
        printWriter.print('\ufeff');
        try (CSVWriter writer = new CSVWriter(printWriter);){
            LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense((Option<PluginLicense>)this.pluginLicenseManager.getLicense());
            if (!licenseCheckResult.isOk()) {
                log.error("Audit logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
                writer.writeNext(new String[]{licenseCheckResult.getMessage()});
            } else {
                writer.writeNext(new String[]{"Time", "Author", "Event Category", "Change Summary", "Changed Object", "IP Address", "Details"});
                List<Event> events = this.dataLayer.readEvents(criteria);
                for (Event event : events) {
                    ArrayList<String> detailStrings = Lists.newArrayList();
                    for (EventDetail detail : event.getDetails()) {
                        if (detail.getUnchangedValue() != null) {
                            detailStrings.add(String.format("Name: %s\nValue: %s", detail.getName(), detail.getUnchangedValue()));
                            continue;
                        }
                        detailStrings.add(String.format("Name: %s\nOld value: %s\nNew Value: %s", detail.getName(), detail.getOldValue(), detail.getNewValue()));
                    }
                    writer.writeNext(new String[]{event.getTime().toString(), event.getAuthor(), event.getCategory(), event.getSummary(), event.getObject(), event.getIpAddress(), Joiner.on("\n\n").join(detailStrings)});
                }
            }
        }
    }
}

